<?php
session_start();
require_once 'config.php';

// Log the POST data
$logFile = 'logs/debug_assign_task.log';
if (!is_dir('logs')) mkdir('logs');

$log = date('Y-m-d H:i:s') . " - DEBUG ASSIGN_TASK\n";
$log .= "Session: " . json_encode($_SESSION) . "\n";
$log .= "POST data: " . json_encode($_POST) . "\n";

// Check if staff member exists
if (isset($_POST['staff_id'])) {
    $staff_id = intval($_POST['staff_id']);
    $query = "SELECT id, name FROM staff WHERE id = $staff_id";
    $result = $conn->query($query);
    if ($result && $result->num_rows > 0) {
        $staff = $result->fetch_assoc();
        $log .= "Staff found: " . json_encode($staff) . "\n";
    } else {
        $log .= "ERROR: Staff not found with ID: $staff_id\n";
    }
}

// Check if assignment table exists
$query = "SHOW TABLES LIKE 'staff_assignments'";
$result = $conn->query($query);
if ($result && $result->num_rows > 0) {
    $log .= "Table staff_assignments exists\n";
    // Get column info
    $query = "DESCRIBE staff_assignments";
    $result = $conn->query($query);
    $columns = [];
    while ($row = $result->fetch_assoc()) {
        $columns[] = $row['Field'];
    }
    $log .= "Columns: " . implode(", ", $columns) . "\n";
} else {
    $log .= "ERROR: Table staff_assignments does NOT exist\n";
}

file_put_contents($logFile, $log, FILE_APPEND);
echo "Debug logged to: $logFile";
?>
